package gov.va.med.mhv.getcare.converter;

import gov.va.med.mhv.getcare.common.dto.TreatmentFacilityDTO;
import gov.va.med.mhv.getcare.model.TreatmentFacility;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

@Component
public class TreatmentFacilityConverter  {

	
	public static TreatmentFacilityDTO convertTreatmentFacilityDomain(TreatmentFacility e) {
		TreatmentFacilityDTO dto = new TreatmentFacilityDTO();
		
		dto.setAddressCity(e.getAddressCity());
		dto.setAddressCountry(e.getAddressCountry());
		dto.setAddressPostalCode(e.getAddressPostalCode());
		dto.setAddressProvince(e.getAddressProvince());
		dto.setAddressState(e.getAddressState());
		dto.setAddressStreet1(e.getAddressStreet1());
		dto.setAddressStreet2(e.getAddressStreet2());
		dto.setComments(e.getComments());
		dto.setContactInfoFax(e.getContactInfoFax());
		dto.setContactInfoWorkPhone(e.getContactInfoWorkPhone());
		dto.setContactInfoWorkPhoneExt(e.getContactInfoWorkPhoneExt());
		dto.setFacilityName(e.getFacilityName());
		dto.setFacilityType(e.getFacilityType());
		if(e.getHomeFacility() == 1){
			dto.setHomeFacility(true);
		}else{
			dto.setHomeFacility(false);
		}
		
		
		dto.setTreatmentFacilityId(e.getTreatmentFacilityId());
		dto.setUserProfileId(e.getUserProfileId());
		
		return dto;
	}

	
	public static TreatmentFacility convertTreatmentFacilityDTO(TreatmentFacilityDTO dto) {
		TreatmentFacility e = new TreatmentFacility();

		e.setAddressCity(dto.getAddressCity());
		e.setAddressCountry(dto.getAddressCountry());
		e.setAddressPostalCode(dto.getAddressPostalCode());
		e.setAddressProvince(dto.getAddressProvince());
		e.setAddressState(dto.getAddressState());
		e.setAddressStreet1(dto.getAddressStreet1());
		e.setAddressStreet2(dto.getAddressStreet2());
		e.setComments(dto.getComments());
		e.setContactInfoFax(dto.getContactInfoFax());
		e.setContactInfoWorkPhone(dto.getContactInfoWorkPhone());
		e.setContactInfoWorkPhoneExt(dto.getContactInfoWorkPhoneExt());
		e.setFacilityName(dto.getFacilityName());
		e.setFacilityType(dto.getFacilityType());
		if(dto.getHomeFacility()){
			e.setHomeFacility(1);
		}else{
			e.setHomeFacility(0);
		}
		e.setOplock(0);
		e.setTreatmentFacilityId(dto.getTreatmentFacilityId());
		e.setUserProfileId(dto.getUserProfileId());

		return e;
	}
	
	public static List<TreatmentFacilityDTO>  convertTreatementFacilities( List<TreatmentFacility> facilities ){
		List<TreatmentFacilityDTO> dtos = new ArrayList<TreatmentFacilityDTO>();
		for(TreatmentFacility facility : facilities){
			TreatmentFacilityDTO dto = convertTreatmentFacilityDomain(facility);
			dtos.add(dto);
		}
		return dtos;
	}


}
